
create or replace package PlsqlType is
type emp_rec is record (empno number, ename varchar2(10), hiredate date);
type emp_tbl is table of emp_rec index by binary_integer;
procedure set_emp_rec(er emp_rec);
function get_emp_rec(empno number) return emp_rec;
function get_emp_tbl return emp_tbl;
end;
/
show errors

create or replace package body PlsqlType is
emps emp_tbl;
procedure set_emp_rec(er emp_rec) is
begin
  emps(er.empno) := er;
end;
function get_emp_rec(empno number) return emp_rec is
begin
  return emps(empno);
end;
function get_emp_tbl return emp_tbl is 
begin
  return emps;
end;
end;
/
show errors


exit;

declare
a PlsqlType.emp_rec;
begin
a.empno:=1;
a.ename:='tom';
a.hiredate:=TO_DATE('11/FEB/1998');
PlsqlType.set_emp_rec(a);
dbms_output.put_line('INSERT (1, tom)');
end;
/

set serveroutput on;
declare
a PlsqlType.emp_rec;
begin
a := PlsqlType.get_emp_rec(1);
dbms_output.put_line('LOOKUP 1, GET ' || a.ename || ', ' || a.hiredate);
end;
/



